\name{DT_fulldiallel}
\alias{DT_fulldiallel}
\docType{data}
\title{
Full diallel data for corn hybrids
}
\description{
This dataset contains phenotpic data for 36 winter bean hybrids, coming from a full diallel design and evaluated for 9 traits. The column male and female origin columns are included as well. 

}
\usage{data("DT_fulldiallel")}
\format{
  The format is:
 chr "DT_fulldiallel"
}
\source{
This data was generated by a winter bean study and originally included in the agridat package.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{

####=========================================####
#### For CRAN time limitations most lines in the
#### examples are silenced with one '#' mark,
#### remove them and run the examples
####=========================================####
data(DT_fulldiallel)
head(DT)
mix <- mmer(stems~1, random=~female+male, data=DT)
summary(mix)

####=========================================####
####=========================================####
#### Multivariate model example
####=========================================####
####=========================================####

data(DT_fulldiallel)
head(DT)

mix <- mmer(cbind(stems,pods,seeds)~1,
             random=~vs(female) + vs(male),
             rcov=~vs(units),
             data=DT)
summary(mix)
#### genetic variance covariance
cov2cor(mix$sigma$`u:female`)
cov2cor(mix$sigma$`u:male`)
cov2cor(mix$sigma$`u:units`)

}
\keyword{datasets}
\seealso{The core functions of the package \code{\link{mmer}} }
