% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/transforms.lib.R
\name{transformData}
\alias{transformData}
\title{Apply transforms to a data set.}
\usage{
transformData(transforms, data, transform.prefix = "tr_", ...)
}
\arguments{
\item{transforms}{A named character vector of transforms,
where traits are given in the names of the vector.}

\item{data}{A matrix or a data.frame, where the column names represent the names of traits.}

\item{transform.prefix}{A character vector, that is a prefix to be added to the name of transformed trait.
The default value is \code{"tr_"}.}

\item{...}{Additional parameters to be passed to \code{transformTrait} function called inside of \code{transformData}.
For example, it might be a parameter \code{log.base} for \code{\link{transformTrait}} function
in the case \code{transform} is equal to \code{"log"}.}
}
\value{
A matrix or a data.frame of the transformed data.
}
\description{
The function looks for traits in colulms of input data frame,
call \code{\link{transformTrait}} function per trait,
and rename the traits.
By default, the name of a transformed trait is updated
to one with a prefixed given in \code{transform.prefix} argument
(the default value is \code{"tr_"}).
Such renaming is assumed to make the user aware that the trait is transformed.
}
\details{
This function is internally called in \code{solarPolygenic}
if \code{transforms} argument is specified.
In this case of the polygenic analysis,
the transform operation is invisible to the user.
However, it is recommended to manually transform traits
in other linkage and association analyses.
}
\seealso{
\code{\link{availableTransforms}}, \code{\link{transformTrait}}
}

