% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.r
\name{int_to_year}
\alias{int_to_year}
\title{int_to_year}
\usage{
int_to_year(x, month = "06", day = "15")
}
\arguments{
\item{x}{An integer or vector integers.}

\item{month}{The month to be added to the year. Months 1 to 9
should be given as character strings, i.e. "01", "02", etc,
and not 1 or 2o, etc.}

\item{day}{The day to be added to the year. Days should be given
as character strings, i.e., "01" or "02", etc, and not 1 or 2, etc.}
}
\value{
A vector of dates where the input integer forms the year
    component. The day and month components added will by default
    be the 15th of June, so that tick marks will appear in the
    middle of the series on plots. For input, only years 0:9999 are
    accepted.
}
\description{
Convert an integer to a date.
}
\examples{
int_to_year(1960)
class(int_to_year(1960))
int_to_year(1960:1965)
int_to_year(1990, month = "01", day = "30")
}
\author{
Kieran Healy
}
