\name{plot.equiv.clust}
\alias{plot.equiv.clust}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Plot an equiv.clust Object }
\description{
 Plots a hierarchical clustering of node positions as generated by \code{\link{equiv.clust}}.
}
\usage{
plot.equiv.clust(x, labels=NULL, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ An \code{\link{equiv.clust}} object }
  \item{labels}{ A vector of vertex labels }
  \item{\dots}{ Additional arguments to \code{\link{plot.hclust}} }
}
\details{
\code{plot.equiv.clust} is actually a front-end to \code{\link{plot.hclust}}; see the latter for more additional documentation.
}
\value{
None.
}
\references{ Breiger, R.L.; Boorman, S.A.; and Arabie, P.  (1975).  ``An Algorithm for Clustering Relational Data with Applications to Social Network Analysis and Comparison with Multidimensional Scaling.''  \emph{Journal of Mathematical Psychology}, 12, 328-383.

Burt, R.S.  (1976).  ``Positions in Networks.''  \emph{Social Forces}, 55, 93-122.

Wasserman, S., and Faust, K.  \emph{Social Network Analysis: Methods and Applications.}  Cambridge: Cambridge University Press.}
\author{ Carter T. Butts \email{buttsc@uci.edu} }
%\note{  }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

%\section{Requires}{\code{mva}}

\seealso{ \code{\link{equiv.clust}}, \code{\link{plot.hclust}} }

\examples{
#Create a random graph with _some_ edge structure
g.p<-sapply(runif(20,0,1),rep,20)  #Create a matrix of edge 
                                   #probabilities
g<-rgraph(20,tprob=g.p)            #Draw from a Bernoulli graph 
                                   #distribution

#Cluster based on structural equivalence
eq<-equiv.clust(g)
plot(eq)
}
\keyword{ hplot }%-- one or more ...
