% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rflex.zones.R
\name{rflex.zones}
\alias{rflex.zones}
\title{Determine zones for flexibly shaped spatial scan test}
\usage{
rflex.zones(nn, w, cases, ex, alpha1 = 0.2, type = "poisson",
  pop = NULL, cl = NULL, loop = FALSE, verbose = FALSE,
  pfreq = 1)
}
\arguments{
\item{nn}{An n by k matrix providing the k nearest
neighbors of each region, presumably produced by the
\code{\link{knn}} function.}

\item{w}{A binary spatial adjacency matrix for the regions.}

\item{cases}{The number of cases observed in each region.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{alpha1}{The middle p-value threshold.}

\item{type}{The type of scan statistic to implement. The
default is \code{"poisson"}, with the other choice
being \code{"binomial"}.}

\item{pop}{The population size associated with each
region.  The default is \code{NULL} since this argument
is only needed for \code{type = "binomial"}.}

\item{cl}{
A cluster object created by \code{\link[parallel]{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}

\item{loop}{A logical value indicating whether a loop
should be used to implement the function instead of
\code{\link[pbapply]{pbapply}}.  The default is
\code{FALSE}. If \code{TRUE}, then memory-saving steps
are also taken.}

\item{verbose}{A logical value indicating whether
progress messages should be provided.
The default is \code{FALSE}.  If both \code{loop} and
\code{verbose} are \code{TRUE}, informative messages
are displayed that can be useful for diagnosing where
the sequences of connected subgraphs are slowing down
or having problems.}

\item{pfreq}{The frequency that messages are reported
from the loop (if \code{verbose = TRUE}). The default
is \code{pfreq = 1}, meaning a message is returned for
each index of the loop.}
}
\value{
Returns a list of zones to consider for
  clustering.  Each element of the list contains a vector
  with the location ids of the regions in that zone.
}
\description{
\code{rflex.zones} determines the unique zones to
consider for the flexibly shaped spatial scan test of
Tango and Takahashi (2012).  The algorithm uses a
breadth-first search to find all subgraphs connected to
each vertex (region) in the data set of size \eqn{k} or
less with the constraint that the middle p-value of each
region must be less than \code{alpha1}.
}
\examples{
data(nydf)
data(nyw)
coords = cbind(nydf$x, nydf$y)
nn = knn(coords, k = 5)
cases = floor(nydf$cases)
pop = nydf$pop
ex = pop * sum(cases)/sum(pop)
# zones for poisson model
pzones = rflex.zones(nn, w = nyw, cases = cases, ex = ex)
\dontrun{
pzones = rflex.zones(nn, w = nyw, cases = cases,
                      ex = ex, verbose = TRUE)
# zones for binomial model
bzones = rflex.zones(nn, w = nyw, cases = cases, ex = ex,
                     type = "binomial", pop = pop)
}
}
\references{
Tango, T. and Takahashi, K. (2012), A
  flexible spatial scan statistic with a restricted
  likelihood ratio for detecting disease clusters.
  Statist. Med., 31: 4207-4218. <doi:10.1002/sim.5478>
}
\seealso{
rflex.midp
}
\author{
Joshua French
}
