% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_metadata}
\alias{ts_metadata}
\title{Extract list with tree sequence metadata saved by SLiM}
\usage{
ts_metadata(ts)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}
}
\value{
List of metadata fields extracted from the tree-sequence object
}
\description{
Extract list with tree sequence metadata saved by SLiM
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_load(slendr_ts, model)

# extract the list of metadata information from the tree sequence
ts_metadata(ts)
}
