% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_ancestors}
\alias{ts_ancestors}
\title{Extract (spatio-)temporal ancestral history for given nodes/individuals}
\usage{
ts_ancestors(ts, x, verbose = FALSE, complete = TRUE)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}

\item{x}{Either an individual name or an integer node ID}

\item{verbose}{Report on the progress of ancestry path generation?}

\item{complete}{Does every individual in the tree sequence need to have
complete metadata recorded? If \code{TRUE}, only individuals/nodes with
complete metadata will be included in the reconstruction of ancestral
relationships. For instance, nodes added during the coalescent recapitation
phase will not be included because they don't have spatial information
associated with them.}
}
\value{
A table of ancestral nodes of a given tree-sequence node all the
way up to the root of the tree sequence
}
\description{
Extract (spatio-)temporal ancestral history for given nodes/individuals
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_load(slendr_ts, model, simplify = TRUE)

# find the complete ancestry information for a given individual
ts_ancestors(ts, "EUR_1", verbose = TRUE)
}
