% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_history.R
\name{slackr_history}
\alias{slackr_history}
\title{Reads history of a channel.}
\usage{
slackr_history(
  message_count,
  channel = Sys.getenv("SLACK_CHANNEL"),
  token = Sys.getenv("SLACK_TOKEN"),
  posted_to_time = as.numeric(Sys.time()),
  duration,
  posted_from_time,
  paginate = FALSE
)
}
\arguments{
\item{message_count}{The number of messages to retrieve (only when \code{paginate = FALSE}).}

\item{channel}{Channel, private group, or IM channel to send message to. Can be an encoded ID, or a name.}

\item{token}{Authentication token bearing required scopes.}

\item{posted_to_time}{Timestamp of the last post to consider (default:
current time).}

\item{duration}{Number of hours of history to retrieve.  By default retrieves
24 hours of history.}

\item{posted_from_time}{Timestamp of the first post time to consider.}

\item{paginate}{If TRUE, uses the Slack API pagination mechanism, and will retrieve all history inside the timeframe.  Otherwise, makes a single call to the API and retrieves a maximum of \code{message_count} messages.}
}
\value{
A \code{tibble} with message metadata
}
\description{
Returns a dataframe of post history in a channel.
}
\section{Scopes}{


You need one or more of these scopes enabled in your slack app: *
channels:history * groups:history * im:history * mpim:history
}

\references{
\url{https://api.slack.com/methods/conversations.history}
}
