% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_slackr.R
\name{ggslackr}
\alias{ggslackr}
\title{Post a ggplot to a Slack channel}
\usage{
ggslackr(
  plot = last_plot(),
  channels = Sys.getenv("SLACK_CHANNEL"),
  scale = 1,
  width = par("din")[1],
  height = par("din")[2],
  units = NULL,
  dpi = 300,
  limitsize = TRUE,
  token = Sys.getenv("SLACK_TOKEN"),
  file = "ggplot",
  initial_comment = NULL,
  thread_ts = NULL,
  title = NULL,
  device = c("png", "eps", "ps", "pdf", "jpeg", "tiff", "bmp", "svg"),
  ...
)
}
\arguments{
\item{plot}{ggplot object to save, defaults to last plot displayed.}

\item{channels}{Comma-separated list of channel names or IDs where the file will be shared.}

\item{scale}{scaling factor.}

\item{width}{width (defaults to the width of current plotting window).}

\item{height}{height (defaults to the height of current plotting window).}

\item{units}{units for width and height when either one is explicitly specified
(in, cm, or mm).}

\item{dpi}{dpi to use for raster graphics.}

\item{limitsize}{when TRUE (the default), ggsave will not save images larger
than 50x50 inches, to prevent the common error of specifying dimensions in pixels.}

\item{token}{Authentication token bearing required scopes.}

\item{file}{Prefix for filenames (defaults to \code{ggplot}).}

\item{initial_comment}{The message text introducing the file in specified channels.}

\item{thread_ts}{Provide another message's ts value to upload this file as a reply. Never use a reply's ts value; use its parent instead.}

\item{title}{Title of file.}

\item{device}{the file extension to use. Options: "png", "eps", "ps", "pdf", "jpeg", "tiff", "bmp", "svg". Default: "png".}

\item{...}{other arguments passed to graphics device.}
}
\value{
\code{httr} response object (invisibly)
}
\description{
Unlike the \code{\link[=slackr_dev]{slackr_dev()}} function, this one takes a \code{ggplot} object,
eliminating the need to have a graphics device (think use in scripts).
}
\examples{
\dontrun{
slackr_setup()
ggslackr(qplot(mpg, wt, data = mtcars))
}
}
