% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr.R
\name{slackr}
\alias{slackr}
\title{Output R expressions to a Slack channel/user}
\usage{
slackr(..., channel = Sys.getenv("SLACK_CHANNEL"),
  username = Sys.getenv("SLACK_USERNAME"),
  icon_emoji = Sys.getenv("SLACK_ICON_EMOJI"),
  api_token = Sys.getenv("SLACK_API_TOKEN"))
}
\arguments{
\item{...}{expressions to be sent to Slack.com}

\item{channel}{which channel to post the message to (chr)}

\item{username}{what user should the bot be named as (chr)}

\item{icon_emoji}{what emoji to use (chr) \code{""} will mean use the default}

\item{api_token}{your full slack.com API token}
}
\description{
Takes an \code{expr}, evaluates it and sends the output to a Slack
chat destination. Useful for logging, messaging on long compute tasks or
general information sharing.
}
\details{
By default, everyting but \code{expr} will be looked for in a "\code{SLACK_}"
environment variable. You can override or just specify these values directly instead,
but it's probably better to call \code{\link{slackr_setup}} first.
}
\note{
You need a \url{https://www.slack.com} account and will also need to
      setup an API token \url{https://api.slack.com/}
      Also, you can pass in \code{add_user=TRUE} as part of the \code{...}
      parameters and the Slack API will post the message as your logged-in
      user account (this will override anything set in \code{username})
}
\examples{
\dontrun{
slackr_setup()
slackr("iris info", head(iris), str(iris))
}
}
\seealso{
\code{\link{slackr_setup}}, \code{\link{slackr_bot}}, \code{\link{dev_slackr}},
         \code{\link{save_slackr}}, \code{\link{slackr_upload}}
}

