% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horizon.R
\name{createHWT}
\alias{createHWT}
\title{Create and download horizon data from \emph{HeyWhatsThat}}
\usage{
createHWT(lat, lon, elevation = 1.6, name, src = "skyscapeR", verbose = T)
}
\arguments{
\item{lat}{The latitude of the location.}

\item{lon}{The longitude of the location.}

\item{elevation}{(Optional) The elevation of the observer above
ground level in meters. Default is 1.6 meters (eye level).}

\item{name}{(Optional) Name for horizon.}

\item{src}{(Optional) Request source ID for \emph{HeyWhatsThat}. Default is
'skyscapeR'. Only change this if you have been given a source ID by the
creator of \emph{HeyWhatsThat}.}

\item{verbose}{(Optional) Boolean switch to control output. Default is \emph{TRUE}.}
}
\description{
This function send a data request to \emph{HeyWhatsThat}, for the
creation of a horizon profile for a give Lat/Lon and elevation. It
 then downloads the data and saves it as a \emph{skyscapeR.horizon}
  object.
}
\examples{
\dontrun{
# Create and retrieve horizon data for the London Mithraeum:
hor <- createHWT(lat=ten(51,30,45), lon=ten(0,5,26.1), name='London Mithraeum')
}
}
\references{
\href{http://heywhatsthat.com/}{HeyWhatsThat.com}
}
\seealso{
\code{\link{downloadHWT}}
}
