% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pRQF.R
\name{pRQF}
\alias{pRQF}
\title{Probabilities for a Ratio of Quadratic Forms in a Normal Random Vector}
\usage{
pRQF(
  r,
  A,
  B,
  Sigma = diag(nrow(A)),
  algorithm = c("imhof", "davies", "integrate"),
  lower.tail = TRUE,
  usenames = FALSE
)
}
\arguments{
\item{r}{A double representing the value(s) for which \eqn{\Pr(R\le r)} or
\eqn{\Pr(R \ge r)} should be computed.}

\item{A}{A numeric, symmetric matrix that is symmetric}

\item{B}{A numeric, symmetric, non-negative definite matrix having the same
dimensions as \code{A}.}

\item{Sigma}{A numeric, symmetric matrix with the same dimensions as
\code{A} and \code{B}, denoting the covariance matrix of the normal
random vector. Defaults to the identity matrix, corresponding to the case
in which the normal random variables are independent and identically
distributed.}

\item{algorithm}{A character, either \code{"imhof"}, \code{"davies"}, or
\code{"integrate"}. Values \code{"imhof"} and \code{"integrate"}
both implement the Imhof algorithm. The difference is that \code{"imhof"}
means that \code{\link[CompQuadForm]{imhof}} is used, whereas
\code{"integrate"} means that \code{\link[stats]{integrate}} is
used (which is slower). The Imhof algorithm is more precise than the
Davies algorithm.}

\item{lower.tail}{A logical. If \code{TRUE}, the cumulative distribution
function \eqn{\Pr(R \le r)} is computed; if \code{FALSE}, the survival
function \eqn{\Pr(R \ge r)} is computed.}

\item{usenames}{A logical. If \code{TRUE}, the function value has a
\code{names} attribute corresponding to \code{r}.}
}
\value{
A double denoting the probability/ies corresponding to the value(s)
   \code{r}.
}
\description{
This function computes cumulative probabilities (lower or upper tail) on a
   ratio of quadratic forms in a vector of normally distributed
   random variables.
}
\details{
Most of the work is done by other functions, namely
   \code{\link[CompQuadForm]{imhof}}, \code{\link[CompQuadForm]{davies}},
   or \code{\link[stats]{integrate}} (depending on the \code{algorithm}
   argument). It is assumed that the ratio of quadratic forms can be
   expressed as
   \deqn{R = \displaystyle\frac{x' A x}{x' B x}} where \eqn{x} is an
   \eqn{n}-dimensional normally distributed random variable with mean vector
   \eqn{\mu} and covariance matrix \eqn{\Sigma}, and \eqn{A} and
   \eqn{B} are real-valued, symmetric \eqn{n\times n} matrices. Matrix
   \eqn{B} must be non-negative definite to ensure that the denominator of
   the ratio of quadratic forms is nonzero.

The function makes use of the fact that a probability statement involving a
   ratio of quadratic forms can be rewritten as a probability statement
   involving a quadratic form. Hence, methods for computing probabilities
   for a quadratic form in normal random variables, such as the Imhof
   algorithm \insertCite{Imhof61}{skedastic} or the Davies algorithm
   \insertCite{Davies80}{skedastic} can be applied to the rearranged
   expression to obtain the probability for the ratio of quadratic forms.
   Note that the Ruben-Farebrother algorithm (as implemented in
   \code{\link[CompQuadForm]{farebrother}}) cannot be used here because the
   \eqn{A} matrix within the quadratic form (after rearrangement of the
   probability statement involving a ratio of quadratic forms) is not in
   general positive semi-definite.
}
\examples{
n <- 20
A <- matrix(data = 1, nrow = n, ncol = n)
B <- diag(n)
pRQF(r = 1, A = A, B = B)
pRQF(r = 1, A = A, B = B, algorithm = "integrate")
pRQF(r = 1:3, A = A, B = B, algorithm = "davies")

}
\references{
{\insertAllCited{}}
}
\seealso{
\insertCite{Duchesne10;textual}{skedastic}, the article associated
   with the \code{\link[CompQuadForm]{imhof}} and
   \code{\link[CompQuadForm]{davies}} functions.
}
