% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_str.R
\name{group_str}
\alias{group_str}
\title{Group near elements of string vectors}
\usage{
group_str(
  strings,
  precision = 2,
  strict = FALSE,
  trim.whitespace = TRUE,
  remove.empty = TRUE,
  verbose = FALSE,
  maxdist
)
}
\arguments{
\item{strings}{Character vector with string elements.}

\item{precision}{Maximum distance ("precision") between two string elements,
which is allowed to treat them as similar or equal. Smaller values mean
less tolerance in matching.}

\item{strict}{Logical; if \code{TRUE}, value matching is more strictly. See 'Examples'.}

\item{trim.whitespace}{Logical; if \code{TRUE} (default), leading and trailing white spaces will
be removed from string values.}

\item{remove.empty}{Logical; if \code{TRUE} (default), empty string values will be removed from the
character vector \code{strings}.}

\item{verbose}{Logical; if \code{TRUE}, the progress bar is displayed when computing the distance matrix.
Default in \code{FALSE}, hence the bar is hidden.}

\item{maxdist}{Deprecated. Please use \code{precision} now.}
}
\value{
A character vector where similar string elements (values) are recoded
          into a new, single value. The return value is of same length as
          \code{strings}, i.e. grouped elements appear multiple times, so
          the count for each grouped string is still avaiable (see 'Examples').
}
\description{
This function groups elements of a string vector (character or string
               variable) according to the element's distance ('similatiry'). The
               more similar two string elements are, the higher is the
               chance to be combined into a group.
}
\examples{
oldstring <- c("Hello", "Helo", "Hole", "Apple",
               "Ape", "New", "Old", "System", "Systemic")
newstring <- group_str(oldstring)

# see result
newstring

# count for each groups
table(newstring)

# print table to compare original and grouped string
frq(oldstring)
frq(newstring)

# larger groups
newstring <- group_str(oldstring, precision = 3)
frq(oldstring)
frq(newstring)

# be more strict with matching pairs
newstring <- group_str(oldstring, precision = 3, strict = TRUE)
frq(oldstring)
frq(newstring)

}
\seealso{
\code{\link{str_find}}
}
