% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliab_test.R
\name{reliab_test}
\alias{reliab_test}
\title{Performs a reliability test on an item scale}
\usage{
reliab_test(x, scale.items = FALSE, digits = 3)
}
\arguments{
\item{x}{\code{data.frame} with items (from a scale).}

\item{scale.items}{Logical, if \code{TRUE}, the data frame's vectors will be scaled. Recommended,
when the variables have different measures / scales.}

\item{digits}{Amount of digits for Cronbach's Alpha and correlation values in
returned data frame.}
}
\value{
A data frame with the corrected item-total correlations (item discrimination)
          and Cronbach's alpha (if item deleted) for each item of the scale, or
          \code{NULL} if data frame had too less columns.
}
\description{
This function calculates the item discriminations (corrected item-total
               correlations for each item of \code{x} with the remaining items) and
               the Cronbach's alpha for each item, if it was deleted from the
               scale.
}
\note{
This function is similar to a basic reliability test in SPSS. The correlations in
        the Item-Total-Statistic are a computed correlation of each item against the sum
        of the remaining items (which are thus treated as one item).
}
\examples{
# Data from the EUROFAMCARE sample dataset
data(efc)

# retrieve variable and value labels
varlabs <- get_label(efc)

# recveive first item of COPE-index scale
start <- which(colnames(efc) == "c82cop1")
# recveive last item of COPE-index scale
end <- which(colnames(efc) == "c90cop9")

# create data frame with COPE-index scale
x <- data.frame(efc[, c(start:end)])
colnames(x) <- varlabs[c(start:end)]

\dontrun{
library(sjPlot)
sjt.df(reliab_test(x), describe = FALSE, showCommentRow = TRUE,
       commentString = sprintf("Cronbach's &alpha;=\%.2f", cronb(x)))}

# Compute PCA on Cope-Index, and perform a
# reliability check on each extracted factor.
\dontrun{
factors <- sjt.pca(x)$factor.index
findex <- sort(unique(factors))
library(sjPlot)
for (i in 1:length(findex)) {
 rel.df <- subset(x, select = which(factors == findex[i]))
 if (ncol(rel.df) >= 3) {
   sjt.df(reliab_test(rel.df), describe = FALSE, showCommentRow = TRUE,
          useViewer = FALSE, title = "Item-Total-Statistic",
          commentString = sprintf("Scale's overall Cronbach's &alpha;=\%.2f",
                                  cronb(rel.df)))
   }
 }}

}
\seealso{
\code{\link{cronb}}
}

