\name{sjp.glm.ma}
\alias{sjp.glm.ma}
\title{Plot model assumptions of glm's}
\usage{
sjp.glm.ma(logreg, showOriginalModelOnly = TRUE)
}
\arguments{
  \item{logreg}{a fitted glm-model}

  \item{showOriginalModelOnly}{if \code{TRUE} (default),
  only the model assumptions of the fitted model
  \code{logreg} are plotted. if \code{FALSE}, the model
  assumptions of an updated model where outliers are
  automatically excluded are also plotted.}
}
\value{
an updated fitted generalized linear model where outliers
are dropped out.
}
\description{
Plots model assumptions of generalized linear models to
verify if generalized linear regression is applicable
}
\examples{
# prepare dichotomous dependent variable
y <- ifelse(swiss$Fertility<median(swiss$Fertility), 0, 1)

# fit model
fitOR <- glm(y ~ swiss$Education + swiss$Examination + swiss$Infant.Mortality + swiss$Catholic,
             family=binomial(link="logit"))

# plot model assumptions
sjp.glm.ma(fitOR)
}
\seealso{
\code{\link{sjp.glm}}
}

