% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_bands.R
\name{sits_bands}
\alias{sits_bands}
\alias{sits_bands.sits}
\alias{sits_bands.raster_cube}
\alias{sits_bands.patterns}
\alias{sits_bands.sits_model}
\alias{sits_bands.default}
\alias{sits_bands<-}
\alias{sits_bands<-.sits}
\alias{sits_bands<-.raster_cube}
\alias{sits_bands<-.default}
\title{Get the names of the bands}
\usage{
sits_bands(x)

\method{sits_bands}{sits}(x)

\method{sits_bands}{raster_cube}(x)

\method{sits_bands}{patterns}(x)

\method{sits_bands}{sits_model}(x)

\method{sits_bands}{default}(x)

sits_bands(x) <- value

\method{sits_bands}{sits}(x) <- value

\method{sits_bands}{raster_cube}(x) <- value

\method{sits_bands}{default}(x) <- value
}
\arguments{
\item{x}{Valid sits tibble (time series or a cube)}

\item{value}{New value for the bands}
}
\value{
A vector with the names of the bands.
}
\description{
Finds the names of the bands of a set of time series or of a data cube
}
\examples{
if (sits_run_examples()) {
    # Create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # Get the bands from a daya cube
    bands <- sits_bands(cube)
    # Get the bands from a sits tibble
    bands <- sits_bands(samples_modis_ndvi)
    # Get the bands from patterns
    bands <- sits_bands(sits_patterns(samples_modis_ndvi))
    # Get the bands from ML model
    rf_model <- sits_train(samples_modis_ndvi, sits_rfor())
    bands <- sits_bands(rf_model)
    # Set the bands for a SITS time series
    sits_bands(samples_modis_ndvi) <- "NDVI2"
    # Set the bands for a SITS cube
    sits_bands(cube) <- "NDVI2"
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}
}
