% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_data.R
\name{genMiss}
\alias{genMiss}
\title{Generate missing data}
\usage{
genMiss(
  dtName,
  missDefs,
  idvars,
  repeated = FALSE,
  periodvar = "period",
  envir = parent.frame()
)
}
\arguments{
\item{dtName}{Name of complete data set}

\item{missDefs}{Definitions of missingness}

\item{idvars}{Index variables}

\item{repeated}{Indicator for longitudinal data}

\item{periodvar}{Name of variable that contains period}

\item{envir}{parent.frame() by default, allows functionality with double-dot
notation}
}
\value{
Missing data matrix indexed by idvars (and period if relevant)
}
\description{
Generate missing data
}
\examples{
def1 <- defData(varname = "m", dist = "binary", formula = .5)
def1 <- defData(def1, "u", dist = "binary", formula = .5)
def1 <- defData(def1, "x1", dist = "normal", formula = "20*m + 20*u", variance = 2)
def1 <- defData(def1, "x2", dist = "normal", formula = "20*m + 20*u", variance = 2)
def1 <- defData(def1, "x3", dist = "normal", formula = "20*m + 20*u", variance = 2)

dtAct <- genData(1000, def1)

defM <- defMiss(varname = "x1", formula = .15, logit.link = FALSE)
defM <- defMiss(defM, varname = "x2", formula = ".05 + m * 0.25", logit.link = FALSE)
defM <- defMiss(defM, varname = "x3", formula = ".05 + u * 0.25", logit.link = FALSE)
defM <- defMiss(defM, varname = "u", formula = 1, logit.link = FALSE) # not observed
defM

# Generate missing data matrix

missMat <- genMiss(dtAct, defM, idvars = "id")
missMat

# Generate observed data from actual data and missing data matrix

dtObs <- genObs(dtAct, missMat, idvars = "id")
dtObs
}
\seealso{
\code{\link{defMiss}}, \code{\link{genObs}}
}
\concept{missing}
