% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defDataAdd.R
\name{defDataAdd}
\alias{defDataAdd}
\title{Add single row to definitions table that will be used to add data to an
existing data.table}
\usage{
defDataAdd(dtDefs = NULL, varname, formula, variance = 0, dist = "normal",
  link = "identity")
}
\arguments{
\item{dtDefs}{Name of definition table to be modified. Null if this is a new definition.}

\item{varname}{Name (string) of new variable}

\item{formula}{An R expression for mean (string)}

\item{variance}{Number}

\item{dist}{Distribution. For possibilities, see details}

\item{link}{The link function for the mean, see details}
}
\value{
A data.table named dtName that is an updated data definitions table
}
\description{
Add single row to definitions table that will be used to add data to an
existing data.table
}
\examples{
# New data set

def <- defData(varname = "xNr", dist = "nonrandom", formula=7, id = "idnum")
def <- defData(def, varname="xUni", dist="uniform", formula="10;20")

dt <- genData(10, def)

# Add columns to dt

def2 <- defDataAdd(varname="y1", formula = 10, variance = 3)
def2 <- defDataAdd(def2, varname="y2", formula = .5, dist = "binary")
def2

dt <- addColumns(def2, dt)
dt
}
