% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defCondition.R
\name{defCondition}
\alias{defCondition}
\title{Add single row to definitions table of conditions that will be used to add data to an
existing definitions table}
\usage{
defCondition(
  dtDefs = NULL,
  condition,
  formula,
  variance = 0,
  dist = "normal",
  link = "identity"
)
}
\arguments{
\item{dtDefs}{Name of definition table to be modified. Null if this is a new definition.}

\item{condition}{Formula specifying condition to be checked}

\item{formula}{An R expression for mean (string)}

\item{variance}{Number}

\item{dist}{Distribution. For possibilities, see details}

\item{link}{The link function for the mean, see details}
}
\value{
A data.table named dtName that is an updated data definitions table
}
\description{
Add single row to definitions table of conditions that will be used to add data to an
existing definitions table
}
\examples{
# New data set

def <- defData(varname = "x", dist = "noZeroPoisson", formula=5)
def <- defData(def, varname="y", dist="normal", formula=0, variance=9)

dt <- genData(10, def)

# Add columns to dt

defC <- defCondition(condition = "x == 1", formula = "5 + 2*y",
                     variance = 1,dist = "normal")

defC <- defCondition(defC, condition = "x <= 5 & x >= 2", formula = "3 - 2*y",
                     variance = 1, dist="normal")

defC <- defCondition(defC, condition = "x >= 6", formula = 1,
                     variance = 1, dist="normal")

defC

# Add conditional column with field name "z"

dt <- addCondition(defC, dt, "z")
dt
}
