\name{fixParms}
\alias{fixParms}
\alias{fixParms-methods}
\alias{fixParms,simObj-method}

\alias{fixInit}
\alias{fixInit-methods}
\alias{fixInit,simObj-method}

\alias{fixTimes}
\alias{fixTimes-methods}
\alias{fixTimes,simObj-method}


\title{
  Fix parms, init or times of simecol objects
}
\description{
    The functions invoke an editor dialog for parameters, initial
    values or time steps of \code{simObj} objects and then assign the
    new (edited) version of \code{x} in the user's workspace. A Tcl/Tk
    version or spreadsheet editor is displayed when possible depending
    on the structure of the respective slot.
}
\usage{
  fixParms(x)
  fixTimes(x)
  fixInit(x)
}
\arguments{
  \item{x}{a valid instance of the \code{simObj} class.}
}
\seealso{
  \code{\link{sEdit}}, \code{\link{simObj}}, \code{\link{parms}}
}
\examples{
  \dontrun{
    data(lv)        # load basic Lotka-Volterra model
    fixParms(lv) 
    plot(sim(lv))

    data(conway)    # Conway's game of life
    init(conway) <- matrix(0, 10, 10)
    fixInit(conway) # enter some "1"
    sim(conway, animate=TRUE, delay=100)
  }
}

\keyword{utilities}
