% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions.R
\name{rconst}
\alias{rconst}
\title{Constant (Degenerate) Node Distribution}
\usage{
rconst(n, const)
}
\arguments{
\item{n}{Sample size.}

\item{const}{A vector of constant values.}
}
\value{
A vector of constants of length \code{n}.
}
\description{
Wrapper for a constant value (degenerate) distribution.
}
\examples{
#---------------------------------------------------------------------------------------
# Specifying and simulating from a DAG with 1 Bernoulli and 2 constant nodes
#---------------------------------------------------------------------------------------
D <- DAG.empty()
D <- D + node("W1", distr="rbern", prob=0.05)
D <- D + node("W2", distr="rconst", const=1)
D <- D + node("W3", distr="rconst", const=ifelse(W1==1,5,10))
Dset <- set.DAG(D)
simdat <- simobs(Dset, n=200, rndseed=1)
}

