% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/times.R
\name{simCrackTime}
\alias{simCrackTime}
\alias{simCrackTime.cylinder}
\alias{simCrackTime.oblate}
\alias{simCrackTime.prolate}
\alias{simCrackTime.sphere}
\title{Defect failure times}
\usage{
simCrackTime(S, stress, vickers, param,
  parallel.option = getOption("parallel.option", "lapply"))

\method{simCrackTime}{oblate}(S, stress, vickers, param,
  parallel.option = getOption("parallel.option", "lapply"))

\method{simCrackTime}{prolate}(S, stress, vickers, param,
  parallel.option = getOption("parallel.option", "lapply"))

\method{simCrackTime}{cylinder}(S, stress, vickers, param,
  parallel.option = getOption("parallel.option", "lapply"))

\method{simCrackTime}{sphere}(S, stress, vickers, param,
  parallel.option = getOption("parallel.option", "lapply"))
}
\arguments{
\item{S}{geometry objects system}

\item{stress}{the applied stress level}

\item{vickers}{Vickers hardness}

\item{param}{simulation parameter list of parameter vectors for both phases}

\item{parallel.option}{optional, in case of \code{mclapply} the function 
\code{mclapply} is used from the parallel package}
}
\value{
a list with the following elements:
			\itemize{
				\item{id}{ id of particle }
				\item{U}{ crack failure time }
				\item{V}{ delamination failure time }
				\item{T}{ the minimum of both failure times}
				\item{B}{ failure type, either 0  for particle crack or 1 for particle delamination }
				\item{A}{ projection area set to zero for later use }
				\item{label}{ either \code{label="P"} for primary phase or \code{label="F"} 
							  for secondary phase }
			}
}
\description{
Simulation of individual defect failure times. For a secondary phase only 
the defect type "delamination" is considered.
}
\author{
Felix Ballani, Markus Baaske
}

