% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivalFunctions.R
\name{PWCsurvPFS}
\alias{PWCsurvPFS}
\title{PFS Survival Function from Piecewise Constant Hazards}
\usage{
PWCsurvPFS(t, h01, h02, pw01, pw02)
}
\arguments{
\item{t}{(\code{numeric})\cr study time-points.}

\item{h01}{(\verb{numeric vector})\cr constant transition hazards for 0 to 1 transition.}

\item{h02}{(\verb{numeric vector})\cr constant transition hazards for 0 to 2 transition.}

\item{pw01}{(\verb{numeric vector})\cr time intervals for the piecewise constant hazards \code{h01}.}

\item{pw02}{(\verb{numeric vector})\cr time intervals for the piecewise constant hazards \code{h02}.}
}
\value{
This returns the value of PFS survival function at time t.
}
\description{
PFS Survival Function from Piecewise Constant Hazards
}
\examples{
PWCsurvPFS(1:5, c(0.3, 0.5), c(0.5, 0.8), c(0, 4), c(0, 8))
}
