% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmoidalFitFunctions.R
\name{sigmoidalFitFunction}
\alias{sigmoidalFitFunction}
\title{Sigmoidal fit function}
\usage{
sigmoidalFitFunction(dataInput, tryCounter, startList = list(maximum = 1,
  slope = 36, midPoint = 0.3333333), lowerBounds = c(maximum = 0.3, slope =
  1e-05, midPoint = 0.3125 - 0.8333333), upperBounds = c(maximum = 1.5, slope
  = 180, midPoint = 0.3125 + 0.8333333), min_Factor = 1/2^20,
  n_iterations = 1000)
}
\arguments{
\item{dataInput}{a data frame composed of two columns. One is for time and the other is for intensity. Should be normalized data generated by normalizeData.}

\item{tryCounter}{the number of times the data is fit using the fitting algorithm.}

\item{startList}{the initial set of parameters that algorithm tries to fit. The parameters are 'maximumValue' that represents the maximum value that the function can take,  'slopeValue' that represents the slope in normalized y axis, and 'midPointValue' that represents the midpoint.}

\item{lowerBounds}{the lower bounds for the randomly generated start parameters.}

\item{upperBounds}{the upper bounds for the randomly generated start parameters.}

\item{min_Factor}{the minimum step size in the iterations used by the fitting algorithm.}

\item{n_iterations}{the maximum number of iterations used by the fitting algorithm.}
}
\value{
Returns fitted parameters for the sigmoidal model.
}
\description{
Fits a sigmoidal curve to given data by using likelihood maximization (LM) and gives the parameters (maximum, slope and midpoint) describing the sigmoidal fit as output. It also provides information about the goodness of fit such as AIC, BIC, residual sum of squares, and log likelihood.
}
\examples{
time=seq(3,24,0.5)

#simulate intensity data and add noise
noise_parameter=0.1
intensity_noise=stats::runif(n = length(time),min = 0,max = 1)*noise_parameter
intensity=sigmoidalFitFormula(time, maximum=4, slope=1, midPoint=8)
intensity=intensity+intensity_noise

dataInput=data.frame(intensity=intensity,time=time)
normalizedInput = normalizeData(dataInput)
parameterVector<-sigmoidalFitFunction(normalizedInput,tryCounter=2)

#Check the results
if(parameterVector$isThisaFit){
intensityTheoretical=sigmoidalFitFormula(time,
                                        maximum=parameterVector$maximum_Estimate,
                                        slope=parameterVector$slope_Estimate,
                                        midPoint=parameterVector$midPoint_Estimate)

comparisonData=cbind(dataInput,intensityTheoretical)

require(ggplot2)
ggplot(comparisonData)+
 geom_point(aes(x=time, y=intensity))+
 geom_line(aes(x=time,y=intensityTheoretical))+
 expand_limits(x = 0, y = 0)}

if(!parameterVector$isThisaFit){print(parameterVector)}

}

