% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numberInput.R
\name{numberInput}
\alias{numberInput}
\title{Create a numeric input}
\usage{
numberInput(
  inputId,
  label,
  value = NULL,
  min = NA,
  max = NA,
  step = NA,
  placeholder = NULL,
  width = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value. NULL by default.}

\item{min}{Minimum allowed value}

\item{max}{Maximum allowed value}

\item{step}{Interval to use when stepping between min and max}

\item{placeholder}{A character string giving the user a hint as to what can
be entered into the control. Internet Explorer 8 and 9 do not support this
option.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'}; see
\code{\link[=validateCssUnit]{validateCssUnit()}}.}
}
\value{
A numeric input control that can be added to a UI definition.
}
\description{
Create an input control for entry of numeric values. This is identical to
\code{\link[shiny:numericInput]{shiny::numericInput()}} but is more flexible in \strong{not} requiring an initial
value and in allowing placeholders.
}
\section{Server value}{
 A numeric vector of length 1.
}

\examples{

if (interactive()) {
library(shiny)
library(shinysurveys)

ui <- fluidPage(
  numberInput("obs", "Observations:", placeholder = "How many do you see?", min = 1, max = 100),
  verbatimTextOutput("value")
)
server <- function(input, output) {
  output$value <- renderText({ input$obs })
}
shinyApp(ui, server)
}

}
\seealso{
\code{\link[shiny:updateNumericInput]{shiny::updateNumericInput()}}
}
