% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhanced-boxes.R
\name{socialBox}
\alias{socialBox}
\title{AdminLTE2 social box}
\usage{
socialBox(..., src = NULL, title = NULL, subtitle = NULL,
  width = 6, height = NULL, collapsible = TRUE, closable = TRUE,
  comments = NULL, footer = NULL, footer_padding = TRUE)
}
\arguments{
\item{...}{body content. May include attachmentBlock for instance.}

\item{src}{header image, if any.}

\item{title}{box title.}

\item{subtitle}{box subtitle.}

\item{width}{box width (between 1 and 12).}

\item{height}{box height.}

\item{collapsible}{If TRUE, display a button in the upper right that allows the user to collapse the box.}

\item{closable}{If TRUE, display a button in the upper right that allows the user to close the box.}

\item{comments}{slot for boxComments.}

\item{footer}{box footer, if any.}

\item{footer_padding}{TRUE by default: whether the footer has margin or not.}
}
\description{
Create social box
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     socialBox(
      title = "Social Box",
      subtitle = "example-01.05.2018",
      src = "https://adminlte.io/themes/AdminLTE/dist/img/user4-128x128.jpg",
      "Some text here!",
      attachmentBlock(
       src = "http://kiev.carpediem.cd/data/afisha/o/2d/c7/2dc7670333.jpg",
       title = "Test",
       title_url = "http://google.com",
       "This is the content"
      ),
      comments = tagList(
       lapply(X = 1:10, FUN = function(i) {
        boxComment(
          src = "https://adminlte.io/themes/AdminLTE/dist/img/user3-128x128.jpg",
          title = paste("Comment", i),
          date = "01.05.2018",
          paste0("The ", i, "-th comment")
        )
       })
      ),
      footer = "The footer here!"
     )
    ),
    title = "socialBox"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
