% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-awesomeradio.R
\name{updateAwesomeRadio}
\alias{updateAwesomeRadio}
\title{Change the value of a radio input on the client}
\usage{
updateAwesomeRadio(session, inputId, label = NULL, choices = NULL,
  selected = NULL, inline = FALSE, status = "primary",
  checkbox = FALSE)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{inputId}{The id of the input object.}

\item{label}{Input label.}

\item{choices}{List of values to select from (if elements of the list are named then that name rather than the value is displayed to the user)}

\item{selected}{The initially selected value}

\item{inline}{If TRUE, render the choices inline (i.e. horizontally)}

\item{status}{Color of the buttons}

\item{checkbox}{Checkbox style}
}
\description{
Change the value of a radio input on the client
}
\examples{
\dontrun{

if (interactive()) {

library("shiny")
library("shinyWidgets")


ui <- fluidPage(
  awesomeRadio(
    inputId = "somevalue",
    choices = c("A", "B", "C"),
    label = "My label"
  ),

  verbatimTextOutput(outputId = "res"),

  actionButton(inputId = "updatechoices", label = "Random choices"),
  textInput(inputId = "updatelabel", label = "Update label")
)

server <- function(input, output, session) {

  output$res <- renderPrint({
    input$somevalue
  })

  observeEvent(input$updatechoices, {
    updateAwesomeRadio(
      session = session, inputId = "somevalue",
      choices = sample(letters, sample(2:6))
    )
  })

  observeEvent(input$updatelabel, {
    updateAwesomeRadio(
      session = session, inputId = "somevalue",
      label = input$updatelabel
    )
  }, ignoreInit = TRUE)

}

shinyApp(ui = ui, server = server)

}

}
}
\seealso{
\code{\link{awesomeRadio}}
}
