% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Page.R
\name{f7SplitLayout}
\alias{f7SplitLayout}
\title{Framework7 split layout}
\usage{
f7SplitLayout(
  ...,
  navbar,
  sidebar,
  toolbar = NULL,
  panels = NULL,
  appbar = NULL
)
}
\arguments{
\item{...}{Content.}

\item{navbar}{Slot for \link{f7Navbar}.}

\item{sidebar}{Slot for \link{f7Panel}. Particularly we expect the following code:
\code{f7Panel(title = "Sidebar", side = "left", theme = "light", "Blabla", style = "reveal")}}

\item{toolbar}{Slot for \link{f7Toolbar}.}

\item{panels}{Slot for \link{f7Panel}. Expect only a right panel, for instance:
\code{f7Panel(title = "Left Panel", side = "right", theme = "light", "Blabla", style = "cover")}}

\item{appbar}{Slot for \link{f7Appbar}.}
}
\description{
This is a modified version of the \link{f7SingleLayout}.
It is intended to be used with tablets.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     title = "Split layout",
     f7SplitLayout(
       sidebar = f7Panel(
         id = "sidebar",
         title = "Sidebar",
         side = "left",
         theme = "dark",
         f7PanelMenu(
           id = "menu",
           f7PanelItem(tabName = "tab1", title = "Tab 1", icon = f7Icon("envelope"), active = TRUE),
           f7PanelItem(tabName = "tab2", title = "Tab 2", icon = f7Icon("house"))
         ),
         uiOutput("selected_tab")
       ),
       navbar = f7Navbar(
         title = "Split Layout",
         hairline = FALSE,
         shadow = TRUE
       ),
       toolbar = f7Toolbar(
         position = "bottom",
         f7Link(label = "Link 1", href = "https://www.google.com"),
         f7Link(label = "Link 2", href = "https://www.google.com")
       ),
       # main content
       f7Items(
         f7Item(
           tabName = "tab1",
           f7Slider("obs", "Number of observations:",
                       min = 0, max = 1000, value = 500
           ),
           plotOutput("distPlot")
         ),
         f7Item(tabName = "tab2", "Tab 2 content")
       )
     )
   ),
   server = function(input, output) {

     output$selected_tab <- renderUI({
      HTML(paste0("Selected tab: ", strong(input$menu)))
     })

     output$distPlot <- renderPlot({
       dist <- rnorm(input$obs)
       hist(dist)
     })
   }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
