% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Fab.R
\name{f7Fabs}
\alias{f7Fabs}
\alias{updateF7Fabs}
\alias{f7FabMorphTarget}
\title{Framework7 container for floating action button (FAB)}
\usage{
f7Fabs(
  ...,
  id = NULL,
  position = c("right-top", "right-center", "right-bottom", "left-top", "left-center",
    "left-bottom", "center-center", "center-top", "center-bottom"),
  color = NULL,
  extended = FALSE,
  label = NULL,
  sideOpen = c("left", "right", "top", "bottom", "center"),
  morph = FALSE,
  morphTarget = NULL
)

updateF7Fabs(id, session = shiny::getDefaultReactiveDomain())

f7FabMorphTarget(tag)
}
\arguments{
\item{...}{Slot for \link{f7Fab}.}

\item{id}{The id of the input object.}

\item{position}{Container position.}

\item{color}{Container color.}

\item{extended}{If TRUE, the FAB will be wider. This allows to use a label (see below).}

\item{label}{Container label. Only if extended is TRUE.}

\item{sideOpen}{When the container is pressed, indicate where buttons are displayed.}

\item{morph}{Whether to allow the FAB to transofrm into another UI element.}

\item{morphTarget}{CSS selector of the morph target: \code{".toolbar"} for instance.}

\item{session}{The Shiny session object, usually the default value will suffice.}

\item{tag}{Target tag.}
}
\description{
\link{f7Fabs} hosts multiple \link{f7Fab}.

\link{updateF7Fabs} toggles \link{f7Fabs} on the server side.

\link{f7FabMorphTarget} convert a tag into a target morphing.
See \url{https://v5.framework7.io/docs/floating-action-button.html#fab-morph}.
}
\note{
The background color might be an issue depending on the parent container. Consider
it experimental.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "Floating action buttons",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Fabs"),
     f7Fabs(
      extended = TRUE,
      label = "Menu",
      position = "center-top",
      color = "yellow",
      sideOpen = "right",
      lapply(1:4, function(i) f7Fab(paste0("btn", i), i))
    ),
    lapply(1:4, function(i) verbatimTextOutput(paste0("res", i))),

    f7Fabs(
      position = "center-center",
      color = "purple",
      sideOpen = "center",
      lapply(5:8, function(i) f7Fab(paste0("btn", i), i))
    ),
    lapply(5:8, function(i) verbatimTextOutput(paste0("res", i))),

    f7Fabs(
      position = "left-bottom",
      color = "pink",
      sideOpen = "top",
      lapply(9:12, function(i) f7Fab(paste0("btn", i), i))
    )
    )

  ),
  server = function(input, output) {
    lapply(1:12, function(i) {
      output[[paste0("res", i)]] <- renderPrint(input[[paste0("btn", i)]])
    })
  }
 )
}

if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "Update f7Fabs",
    f7SingleLayout(
      navbar = f7Navbar(title = "Update f7Fabs"),
      f7Button(inputId = "toggleFabs", label = "Toggle Fabs"),
      f7Fabs(
        position = "center-center",
        id = "fabs",
        lapply(1:3, function(i) f7Fab(inputId = i, label = i))
      )
    )
  ),
  server = function(input, output, session) {
    observe(print(input$fabs))
    observeEvent(input$toggleFabs, {
      updateF7Fabs(id = "fabs")
    })
  }
 )
}
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     f7SingleLayout(
       navbar = f7Navbar(title = "f7Fabs Morph"),
       toolbar = f7Toolbar(
         position = "bottom",
         lapply(1:3, function(i) f7Link(i) \%>\% f7FabClose())
       ) \%>\% f7FabMorphTarget(),
       # put an empty f7Fabs container
       f7Fabs(
         extended = TRUE,
         label = "Open",
         position = "center-top",
         color = "yellow",
         sideOpen = "right",
         morph = TRUE,
         morphTarget = ".toolbar"
       )
     )

   ),
   server = function(input, output) {}
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
