% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Select}
\alias{f7Select}
\title{Create an f7 select input}
\usage{
f7Select(inputId, label, choices, selected = NULL, width = NULL)
}
\arguments{
\item{inputId}{Select input id.}

\item{label}{Select input label.}

\item{choices}{Select input choices.}

\item{selected}{Select input default selected value.}

\item{width}{The width of the input, e.g. \code{400px}, or \code{100\%}.}
}
\description{
Create an f7 select input
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
      navbar = f7Navbar(title = "f7Select"),
      f7Select(
       inputId = "variable",
       label = "Choose a variable:",
       choices = colnames(mtcars)[-1],
       selected = "hp"
      ),
      tableOutput("data")
     )
   ),
   server = function(input, output) {
     output$data <- renderTable({
       mtcars[, c("mpg", input$variable), drop = FALSE]
     }, rownames = TRUE)
   }
 )
}
}
