% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7AutoComplete}
\alias{f7AutoComplete}
\title{Create a Framework7 autocomplete input}
\usage{
f7AutoComplete(
  inputId,
  label,
  placeholder = NULL,
  value = choices[1],
  choices,
  openIn = c("popup", "page", "dropdown"),
  typeahead = TRUE,
  expandInput = TRUE,
  closeOnSelect = FALSE,
  dropdownPlaceholderText = NULL,
  multiple = FALSE
)
}
\arguments{
\item{inputId}{Autocomplete input id.}

\item{label}{Autocomplete label.}

\item{placeholder}{Text to write in the container.}

\item{value}{Autocomplete initial value, if any.}

\item{choices}{Autocomplete choices.}

\item{openIn}{Defines how to open Autocomplete,
can be page or popup (for Standalone) or dropdown.}

\item{typeahead}{Enables type ahead, will prefill input
value with first item in match. Only if openIn is "dropdown".}

\item{expandInput}{If TRUE then input which is used as
item-input in List View will be expanded to full
screen wide during dropdown visible. Only if openIn is "dropdown".}

\item{closeOnSelect}{Set to true and autocomplete will be closed when user picks value.
Not available if multiple is enabled. Only works
when openIn is 'popup' or 'page'.}

\item{dropdownPlaceholderText}{Specify dropdown placeholder text.
Only if openIn is "dropdown".}

\item{multiple}{Whether to allow multiple value selection. Only works
when openIn is 'popup' or 'page'.}
}
\description{
Build a Framework7 autocomplete input
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7AutoComplete"),
     f7AutoComplete(
      inputId = "myautocomplete1",
      placeholder = "Some text here!",
      dropdownPlaceholderText = "Try to type Apple",
      label = "Type a fruit name",
      openIn = "dropdown",
      choices = c('Apple', 'Apricot', 'Avocado', 'Banana', 'Melon',
       'Orange', 'Peach', 'Pear', 'Pineapple')
     ),
     textOutput("autocompleteval1"),
     f7AutoComplete(
      inputId = "myautocomplete2",
      placeholder = "Some text here!",
      openIn = "popup",
      multiple = TRUE,
      label = "Type a fruit name",
      choices = c('Apple', 'Apricot', 'Avocado', 'Banana', 'Melon',
                  'Orange', 'Peach', 'Pear', 'Pineapple')
     ),
     verbatimTextOutput("autocompleteval2")
    )
   ),
   server = function(input, output) {
    observe({
     print(input$myautocomplete1)
     print(input$myautocomplete2)
    })
    output$autocompleteval1 <- renderText(input$myautocomplete1)
    output$autocompleteval2 <- renderPrint(input$myautocomplete2)
   }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
