% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonInput.R
\name{commonInput}
\alias{commonInput}
\alias{commonInputs}
\title{Merge multiple input controllers into one}
\usage{
commonInput(inputId, controller, block = TRUE)

commonInputs(inputId, ..., block = TRUE)
}
\arguments{
\item{inputId}{Id to be used to send the grouped controllers input values to application server.}

\item{controller}{Shiny input controller e.g. `shiny::sliderInput` or `shinyWidgets::pickerInput`.}

\item{block}{Should the `controller` value be sent to the server independently?}

\item{...}{Input controllers to be grouped in case of using `commonInputs`.}
}
\description{
Select which input controllers should be treated as one.
Use `commonInput` to group selected controllers or `commonInputs` to group
multiple controllers at once.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    commonInput("val", selectInput("letter", "Letter", letters)),
    commonInput("val", numericInput("number", "Number", min = 0, max = 10, value = 1)),
    commonInputs(
      "val2",
      selectInput("letter2", "Letter", letters),
      numericInput("number2", "Number", min = 0, max = 10, value = 1)
    )
  )

  server <- function(input, output, session) {
    observeEvent(input$val, {
      print(input$val)
    })
    observeEvent(input$val2, {
      print(input$val2)
    })
  }

  shinyApp(ui, server)
}
}
