% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setZoom.R
\name{setZoom}
\alias{setZoom}
\title{Custom zoom}
\usage{
setZoom(id = NULL, class = NULL, scale = 1.05)
}
\arguments{
\item{id}{Use this argument if you want to target an individual element.}

\item{class}{The element to which the zoom should be applied.
For example, class is set to box.}

\item{scale}{Zoom scale. 1.05 by default (5\% bigger than the normal). We do not
recommand using higher values, except in some particular cases.}
}
\description{
Allow to apply a zoom on a given element.
}
\examples{
 if (interactive()) {

  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)
  library(shinyEffects)

  boxTag <- boxPlus(
   title = "Closable box, with label",
   closable = TRUE,
   enable_label = TRUE,
   label_text = 1,
   label_status = "danger",
   status = "warning",
   solidHeader = FALSE,
   collapsible = TRUE,
   p("Box Content")
  )

  shinyApp(
   ui = dashboardPagePlus(
     header = dashboardHeaderPlus(
       enable_rightsidebar = TRUE,
       rightSidebarIcon = "gears"
     ),
     sidebar = dashboardSidebar(),
     body = dashboardBody(

      setZoom(class = "box"),
      setZoom(id = "my-progress"),

      tags$h2("Add zoom to the box class"),
      fluidRow(boxTag, boxTag),
      tags$h2("Add zoom only to the first element using id"),
      tagAppendAttributes(
       verticalProgress(
        value = 10,
        striped = TRUE,
        active = TRUE
       ),
       id = "my-progress"
      ),
      verticalProgress(
        value = 50,
        active = TRUE,
        status = "warning",
        size = "xs"
      ),
      verticalProgress(
        value = 20,
        status = "danger",
        size = "sm",
        height = "60\%"
      )
     ),
     rightsidebar = rightSidebar(),
     title = "DashboardPage"
   ),
   server = function(input, output) { }
  )
}
}
