% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{htmlOutput}
\alias{htmlOutput}
\alias{uiOutput}
\title{Create an HTML output element}
\usage{
htmlOutput(outputId, inline = FALSE, container = if (inline) span else div,
  ...)

uiOutput(outputId, inline = FALSE, container = if (inline) span else div,
  ...)
}
\arguments{
\item{outputId}{output variable to read the value from}

\item{inline}{use an inline (\code{span()}) or block container (\code{div()})
for the output}

\item{container}{a function to generate an HTML element to contain the text}

\item{...}{Other arguments to pass to the container tag function. This is
useful for providing additional classes for the tag.}
}
\value{
An HTML output element that can be included in a panel
}
\description{
Render a reactive output variable as HTML within an application page. The
text will be included within an HTML \code{div} tag, and is presumed to
contain HTML content which should not be escaped.
}
\details{
\code{uiOutput} is intended to be used with \code{renderUI} on the server
side. It is currently just an alias for \code{htmlOutput}.
}
\examples{
htmlOutput("summary")

# Using a custom container and class
tags$ul(
  htmlOutput("summary", container = tags$li, class = "custom-li-output")
)
}

