% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/reactives.R
\name{invalidateLater}
\alias{invalidateLater}
\title{Scheduled Invalidation}
\usage{
invalidateLater(millis, session)
}
\arguments{
\item{millis}{Approximate milliseconds to wait before invalidating the
current reactive context.}

\item{session}{A session object. This is needed to cancel any scheduled
  invalidations after a user has ended the session. If \code{NULL}, then
  this invalidation will not be tied to any session, and so it will still
  occur.}
}
\description{
Schedules the current reactive context to be invalidated in the given number
of milliseconds.
}
\details{
If this is placed within an observer or reactive expression, that object will
be invalidated (and re-execute) after the interval has passed. The
re-execution will reset the invalidation flag, so in a typical use case, the
object will keep re-executing and waiting for the specified interval. It's
possible to stop this cycle by adding conditional logic that prevents the
\code{invalidateLater} from being run.
}
\examples{
\dontrun{
shinyServer(function(input, output, session) {

  observe({
    # Re-execute this reactive expression after 1000 milliseconds
    invalidateLater(1000, session)

    # Do something each time this is invalidated.
    # The isolate() makes this observer _not_ get invalidated and re-executed
    # when input$n changes.
    print(paste("The value of input$n is", isolate(input$n)))
  })

  # Generate a new histogram at timed intervals, but not when
  # input$n changes.
  output$plot <- renderPlot({
    # Re-execute this reactive expression after 2000 milliseconds
    invalidateLater(2000, session)
    hist(isolate(input$n))
  })
})
}
}
\seealso{
\code{\link{reactiveTimer}} is a slightly less safe alternative.
}

