% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_creation.R
\name{create_gsheet_db}
\alias{create_gsheet_db}
\title{Function to create new empty 'googlesheet' database}
\usage{
create_gsheet_db(name = NULL)
}
\arguments{
\item{name}{specify name for 'googlesheet' file. Defaults to random name.}
}
\value{
id of the 'googlesheet' file. After creation you need to provide it to \code{login_server()}.
}
\description{
Function to create new empty 'googlesheet' database
}
\examples{
if(googlesheets4::gs4_has_token()){

gsheet.id <- create_gsheet_db()

# you can then pass 'gsheet.id' to you 'login_server' call
#
# login_server(db_method = "gsheet",
#              gsheet_file = gsheet.id,
#              ...)
#

googledrive::drive_trash(gsheet.id)

}
}
