% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R,
%   R/inputs.R
\name{Calendar}
\alias{Calendar}
\alias{Calendar.shinyInput}
\alias{updateCalendar.shinyInput}
\title{Calendar}
\usage{
Calendar(...)

Calendar.shinyInput(inputId, ..., value = shiny.react::JS("new Date()"))

updateCalendar.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).
}
\description{
The calendar control lets people select and view a single date or a range of dates in their calendar. It’s made up of 3 separate views: the month view, year view, and decade view.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Calendar}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item {\bold{ allFocusable }} {\code{boolean} \cr Allows all dates and buttons to be focused, including disabled ones}
\item {\bold{ autoNavigateOnSelection }} {\code{boolean} \cr Whether the month view should automatically navigate to the next or previous date range depending on the selected date. If this property is set to true and the currently displayed month is March 2017, if the user clicks on a day outside the month, i.e., April 1st, the picker will automatically navigate to the month of April.}
\item {\bold{ className }} {\code{string} \cr Optional class name to add to the root element.}
\item {\bold{ componentRef }} {\verb{IRefObject<ICalendar>} \cr Optional callback to access the ICalendar interface. Use this instead of ref for accessing the public methods and properties of the component.}
\item {\bold{ dateRangeType }} {\code{DateRangeType} \cr The date range type indicating how many days should be selected as the user selects days}
\item {\bold{ dateTimeFormatter }} {\code{ICalendarFormatDateCallbacks} \cr Apply additional formating to dates, for example localized date formatting.}
\item {\bold{ firstDayOfWeek }} {\code{DayOfWeek} \cr The first day of the week for your locale.}
\item {\bold{ firstWeekOfYear }} {\code{FirstWeekOfYear} \cr Defines when the first week of the year should start, FirstWeekOfYear.FirstDay, FirstWeekOfYear.FirstFullWeek or FirstWeekOfYear.FirstFourDayWeek are the possible values}
\item {\bold{ highlightCurrentMonth }} {\code{boolean} \cr Whether the month picker should highlight the current month}
\item {\bold{ highlightSelectedMonth }} {\code{boolean} \cr Whether the month picker should highlight the selected month}
\item {\bold{ isDayPickerVisible }} {\code{boolean} \cr Whether the day picker is shown beside the month picker or hidden.}
\item {\bold{ isMonthPickerVisible }} {\code{boolean} \cr Whether the month picker is shown beside the day picker or hidden.}
\item {\bold{ maxDate }} {\code{Date} \cr If set the Calendar will not allow navigation to or selection of a date later than this value.}
\item {\bold{ minDate }} {\code{Date} \cr If set the Calendar will not allow navigation to or selection of a date earlier than this value.}
\item {\bold{ navigationIcons }} {\code{ICalendarIconStrings} \cr Customize navigation icons using ICalendarIconStrings}
\item {\bold{ onDismiss }} {\verb{() => void} \cr Callback issued when calendar is closed}
\item {\bold{ onSelectDate }} {\verb{(date: Date, selectedDateRangeArray?: Date[]) => void} \cr Callback issued when a date is selected}
\item {\bold{ restrictedDates }} {\code{Date[]} \cr If set the Calendar will not allow selection of dates in this array.}
\item {\bold{ selectDateOnClick }} {\code{boolean} \cr When clicking on "Today", select the date and close the calendar.}
\item {\bold{ shouldFocusOnMount }} {\code{boolean} \cr This property has been removed at 0.80.0 in place of the \code{focus} method, to be removed \@ 1.0.0.}
\item {\bold{ showCloseButton }} {\code{boolean} \cr Whether the close button should be shown or not}
\item {\bold{ showGoToToday }} {\code{boolean} \cr Whether the "Go to today" link should be shown or not}
\item {\bold{ showMonthPickerAsOverlay }} {\code{boolean} \cr Show month picker on top of date picker when visible.}
\item {\bold{ showSixWeeksByDefault }} {\code{boolean} \cr Whether the calendar should show 6 weeks by default.}
\item {\bold{ showWeekNumbers }} {\code{boolean} \cr Whether the calendar should show the week number (weeks 1 to 53) before each week row}
\item {\bold{ strings }} {\code{ICalendarStrings | null} \cr Localized strings to use in the Calendar}
\item {\bold{ today }} {\code{Date} \cr Value of today. If null, current time in client machine will be used.}
\item {\bold{ value }} {\code{Date} \cr Default value of the Calendar, if any}
\item {\bold{ workWeekDays }} {\code{DayOfWeek[]} \cr The days that are selectable when dateRangeType is WorkWeek. If dateRangeType is not WorkWeek this property does nothing.}
\item {\bold{ yearPickerHidden }} {\code{boolean} \cr Whether the year picker is enabled}
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Don’t break the control apart.
\item Include an up and down arrow for navigating between time ranges and a chevron to make the calendar collapsible.
}
}

\subsection{Content}{
\itemize{
\item Use the following format for dates: month, day, year, as in July 31, 2016. When space is limited, use numbers and slashes for dates if the code supports that format and automatically displays the appropriate date format for different locales. For example, 2/16/19.
\item Don't use ordinal numbers (such as 1st, 12th, or 23rd) to indicate a date.
}
}
}

\examples{
library(shiny.fluent)

if (interactive()) {
  shinyApp(
    ui = div(
      Calendar.shinyInput("calendar", value = "2020-06-25T22:00:00.000Z"),
      textOutput("calendarValue"),
      h3("If `value` is missing, default to system date"),
      Calendar.shinyInput("calendar2"),
      textOutput("calendarDefault"),
      h3("If `value` is NULL, also default to system date"),
      Calendar.shinyInput("calendar3", value = NULL),
      textOutput("calendarNull")
    ),
    server = function(input, output) {
      output$calendarValue <- renderText({
        sprintf("Value: \%s", input$calendar)
      })
      output$calendarDefault <- renderText({
        sprintf("Value: \%s", input$calendar2)
      })
      output$calendarNull <- renderText({
        sprintf("Value: \%s", input$calendar3)
      })
    }
  )
}
}
