% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{editBaseline}
\alias{editBaseline}
\title{Edit the Baseline object}
\usage{
editBaseline(baseline, field_name, value)
}
\arguments{
\item{baseline}{The \code{Baseline} S4 object to be edited.}

\item{field_name}{Name of the field in the \code{Baseline} S4 object to be edited.}

\item{value}{The value to set the \code{field_name}.}
}
\value{
A \code{Baseline} object with the field of choice updated.
}
\description{
\code{editBaseline} edits a field in a \code{Baseline} object.
}
\examples{
# Subset example data
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE \%in\% c("IgA", "IgG") & SAMPLE == "+7d")

# Calculate BASELINe
baseline <- calcBaseline(db, 
                         sequenceColumn="SEQUENCE_IMGT",
                         germlineColumn="GERMLINE_IMGT_D_MASK", 
                         testStatistic="focused",
                         regionDefinition=IMGT_V,
                         targetingModel=HH_S5F,
                         nproc = 1)
# Edit the field "description"
baseline <- editBaseline(baseline, field_name = "description", 
                         value = "+7d IgA & IgG")
                                                  
}
\seealso{
See \link{Baseline} for the return object.
}
