% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_models.R
\name{HierarchicalClustering}
\alias{HierarchicalClustering}
\title{(Weighted) hierarchical clustering}
\usage{
HierarchicalClustering(
  xdata,
  nc = NULL,
  Lambda = NULL,
  distance = "euclidean",
  linkage = "complete",
  scale = TRUE,
  row = TRUE,
  ...
)
}
\arguments{
\item{xdata}{data matrix with observations as rows and variables as columns.}

\item{nc}{matrix of parameters controlling the number of clusters in the
underlying algorithm specified in \code{implementation}. If \code{nc} is
not provided, it is set to \code{seq(1, tau*nrow(xdata))}.}

\item{Lambda}{vector of penalty parameters (see argument \code{lambda} in
\code{\link[rCOSA]{cosa2}}). Unweighted distance matrices are used if
\code{Lambda=NULL}.}

\item{distance}{character string indicating the type of distance to use. If
\code{Lambda=NULL}, possible values include \code{"euclidean"},
\code{"maximum"}, \code{"canberra"}, \code{"binary"}, and
\code{"minkowski"} (see argument \code{method} in
\code{\link[stats]{dist}}).  Otherwise, possible values include
\code{"euclidean"} (\code{pwr=2}) or \code{"absolute"} (\code{pwr=1}) (see
argument \code{pwr} in \code{\link[rCOSA]{cosa2}}).}

\item{linkage}{character string indicating the type of linkage used in
hierarchical clustering to define the stable clusters. Possible values
include \code{"complete"}, \code{"single"} and \code{"average"} (see
argument \code{"method"} in \code{\link[stats]{hclust}} for a full list).
Only used if \code{implementation=HierarchicalClustering}.}

\item{scale}{logical indicating if the data should be scaled to ensure that
all variables contribute equally to the clustering of the observations.}

\item{row}{logical indicating if rows (if \code{row=TRUE}) or columns (if
\code{row=FALSE}) contain the items to cluster.}

\item{...}{additional parameters passed to \code{\link[stats]{hclust}},
\code{\link[stats]{dist}}, or \code{\link[rCOSA]{cosa2}}. Parameters
\code{niter} (default to 1) and \code{noit} (default to 100) correspond to
the number of iterations in \code{\link[rCOSA]{cosa2}} to calculate weights
and may need to be modified. Argument \code{pwr} in
\code{\link[rCOSA]{cosa2}} is ignored, please provide \code{distance}
instead.}
}
\value{
A list with: \item{comembership}{an array of binary and symmetric
  co-membership matrices.} \item{weights}{a matrix of median weights by
  feature.}
}
\description{
Runs hierarchical clustering using implementation from
\code{\link[stats]{hclust}}. If \code{Lambda} is provided, clustering is
applied on the weighted distance matrix calculated using the
\code{\link[rCOSA]{cosa2}} algorithm. Otherwise, distances are calculated
using \code{\link[stats]{dist}}. This function is not using stability.
}
\examples{

# Data simulation
set.seed(1)
simul <- SimulateClustering(n = c(10, 10), pk = 50)

# Hierarchical clustering
myhclust <- HierarchicalClustering(
  xdata = simul$data,
  nc = 1:20
)

# Weighted Hierarchical clustering (using COSA)
if (requireNamespace("rCOSA", quietly = TRUE)) {
  myhclust <- HierarchicalClustering(
    xdata = simul$data,
    weighted = TRUE,
    nc = 1:20,
    Lambda = c(0.2, 0.5)
  )
}
}
\references{
\insertRef{COSA}{sharp}

  \insertRef{rCOSA}{sharp}
}
\seealso{
Other clustering algorithms: 
\code{\link{DBSCANClustering}()},
\code{\link{GMMClustering}()},
\code{\link{KMeansClustering}()},
\code{\link{PAMClustering}()}
}
\concept{clustering algorithms}
