\name{Arrowhead}
\alias{Arrowhead}
\title{adds arrowheads to a plot}
\description{adds one or more arrowheads to a plot; shape is either curved, a triangle, a circle or simple}
\usage{Arrowhead(x0, y0, angle=0, arr.length=0.4, arr.width=arr.length/2, 
  arr.adj=0.5, arr.type="curved", lcol="black", lty=1, arr.col=lcol, 
  npoint=5)}
\arguments{
  \item{x0 }{x-coordinates of points at which to draw arrowhead; either one value or a vector}
  \item{y0 }{y-coordinates of points at which to draw arrowhead; either one value or a vector}
  \item{angle }{angle of arrowhead (anti-clockwise, relative to x-axis), in degrees [0,360]; either one value or a vector}
  \item{arr.length }{approximate length of arrowhead, in cm; either one value or a vector}
  \item{arr.width }{approximate width of arrowhead, in cm; either one value or a vector}
  \item{arr.adj }{0,0.5,1 specifying the adjustment of the arrowhead}
  \item{arr.type }{type of arrowhead to draw, one of "simple","curved","triangle","circle"}
  \item{lcol }{line color specifications; either one value or a vector}
  \item{lty }{line type specifications; either one value or a vector}
  \item{arr.col }{color of arrowhead; either one value or a vector}
  \item{npoint }{only if arr.type = "curved": number of points to draw the curve; increase for smoother arrowheads}
}
\author{Karline Soetaert <k.soetaert@nioo.knaw.nl>}
\examples{emptyplot(main="Arrowhead") 
  Arrowhead(x0=runif(10),y0=runif(10),angle=runif(10)*360,
  arr.length=0.3,arr.type="circle",arr.col="green")
  Arrowhead(x0=runif(10),y0=runif(10),angle=runif(10)*360,
  arr.length=0.4,arr.type="curved",arr.col="red")
  Arrowhead(x0=runif(10),y0=runif(10),angle=runif(10)*360,
  arr.length=runif(10),arr.type="triangle",arr.col=rainbow(10))}
\details{x0, y0, angle, arr.length, arr.width, lcol, lty and arr.col can be a vector, of the same length.

  \itemize{
     \item if arr.adj = 0.5, then the centre of the arrowhead is at the point at which it is drawn.    
     \item arr.adj = 1 causes the tip of the arrowhead to touch the point.
     \item arr.adj = 0 causes the base of the arrowhead to touch the point.
}
    The type of the arrowhead is set with "arr.type" which can take the values:
  \itemize{
    \item "simple"  : uses comparable R function arrows  
    \item "triangle": uses filled triangle
    \item "curved"  : draws arrowhead with curved edges
    \item "circle"  : draws circular head}
}
\seealso{\code{\link{Arrows}}}
\keyword{aplot}

