/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.shallot.mcmc;

import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.util.FastMath;
import org.ddahl.shallot.distribution.HasDiscount;
import org.ddahl.shallot.distribution.PartitionModel;
import org.ddahl.shallot.parameter.Discount$;
import org.ddahl.shallot.parameter.partition.Partition;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class DiscountSampler$ {
    public static final DiscountSampler$ MODULE$;

    static {
        new DiscountSampler$();
    }

    public <B extends PartitionModel<A> & HasDiscount<B, A>, A> Tuple2<B, Object> gaussianRandomWalk(HasDiscount<B, A> d, Partition<A> partition, double shape1, double shape2, double standardDeviation, RandomDataGenerator rdg) {
        PartitionModel current = (PartitionModel)d.self();
        double alpha = rdg.nextGaussian(((HasDiscount)((Object)current)).discount().value(), standardDeviation);
        if (alpha < 0.0 || alpha >= 1.0) {
            return new Tuple2((Object)current, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        PartitionModel proposal = (PartitionModel)d.replaceDiscount(Discount$.MODULE$.apply(alpha));
        double logMHRatio = proposal.logProbability(partition) + this.logPrior$1(((HasDiscount)((Object)proposal)).discount().value(), shape1, shape2) - current.logProbability(partition) - this.logPrior$1(((HasDiscount)((Object)current)).discount().value(), shape1, shape2);
        return FastMath.log((double)rdg.nextUniform(0.0, 1.0, false)) <= logMHRatio ? new Tuple2((Object)proposal, (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)current, (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public <B extends PartitionModel<A> & HasDiscount<B, A>, A> Tuple2<B, Object> spikeAndSlabGaussianRandomWalk(HasDiscount<B, A> d, Partition<A> partition, double probOf0, double shape1, double shape2, double standardDeviation, RandomDataGenerator rdg) {
        Tuple2 tuple2;
        PartitionModel current = (PartitionModel)d.self();
        if (((HasDiscount)((Object)current)).discount().value() == 0.0) {
            double alpha = rdg.nextBeta(shape1, shape2);
            PartitionModel proposal = (PartitionModel)d.replaceDiscount(Discount$.MODULE$.apply(alpha));
            double logMHRatio = proposal.logProbability(partition) - current.logProbability(partition);
            tuple2 = FastMath.log((double)rdg.nextUniform(0.0, 1.0, false)) <= logMHRatio ? new Tuple2((Object)proposal, (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)current, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else if (rdg.nextUniform(0.0, 1.0) < probOf0) {
            PartitionModel proposal = (PartitionModel)d.replaceDiscount(Discount$.MODULE$.apply(0.0));
            double logMHRatio = proposal.logProbability(partition) - current.logProbability(partition);
            tuple2 = FastMath.log((double)rdg.nextUniform(0.0, 1.0, false)) <= logMHRatio ? new Tuple2((Object)proposal, (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)current, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            double alpha = rdg.nextGaussian(((HasDiscount)((Object)current)).discount().value(), standardDeviation);
            if (alpha < 0.0 || alpha >= 1.0) {
                return new Tuple2((Object)current, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            PartitionModel proposal = (PartitionModel)d.replaceDiscount(Discount$.MODULE$.apply(alpha));
            double logMHRatio = proposal.logProbability(partition) - current.logProbability(partition);
            tuple2 = FastMath.log((double)rdg.nextUniform(0.0, 1.0, false)) <= logMHRatio ? new Tuple2((Object)proposal, (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)current, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    private final double logPrior$1(double value, double shape1$1, double shape2$1) {
        return (shape1$1 - 1.0) * FastMath.log((double)value) + (shape2$1 - 1.0) * FastMath.log((double)(1.0 - value));
    }

    private final double logPrior$2(double value, double probOf0$1, double shape1$2, double shape2$2) {
        return value != 0.0 ? (shape1$2 - 1.0) * FastMath.log((double)value) + (shape2$2 - 1.0) * FastMath.log((double)(1.0 - value)) : FastMath.log((double)probOf0$1);
    }

    private DiscountSampler$() {
        MODULE$ = this;
    }
}

