library(shadow)

context("inShadow")

test_that("'inShadow' calculation is correct", {
  expect_equal({
    obstacles = rishon[c(2, 4), ]
    # location = surfaceGrid(
    #   obstacles = obstacles,
    #   obstacles_height_field = "BLDG_HT",
    #   res = 10,
    #   offset = 0.01
    # )
    location = new(
      "SpatialPointsDataFrame"
      ,
      data = structure(
        list(
          type = c(
            "roof",
            "roof",
            "roof",
            "roof",
            "roof",
            "roof",
            "roof",
            "roof",
            "roof",
            "roof",
            "roof",
            "roof",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade",
            "facade"
          ),
          seg_id = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            1L,
            4L,
            5L,
            9L,
            10L,
            11L,
            14L,
            16L,
            18L,
            18L,
            1L,
            4L,
            5L,
            9L,
            10L,
            11L,
            14L,
            16L,
            18L,
            18L,
            20L,
            23L,
            24L,
            28L,
            31L,
            32L,
            35L,
            36L,
            37L,
            38L,
            20L,
            23L,
            24L,
            28L,
            31L,
            32L,
            35L,
            36L,
            37L,
            38L
          ),
          xy_id = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            1L,
            2L,
            3L,
            4L,
            5L,
            6L,
            7L,
            8L,
            9L,
            10L,
            1L,
            2L,
            3L,
            4L,
            5L,
            6L,
            7L,
            8L,
            9L,
            10L,
            1L,
            2L,
            3L,
            4L,
            5L,
            6L,
            7L,
            8L,
            9L,
            10L,
            1L,
            2L,
            3L,
            4L,
            5L,
            6L,
            7L,
            8L,
            9L,
            10L
          ),
          facade_az = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            226.322278325374,
            152.204221415427,
            242.13181892178,
            316.200889778535,
            333.421572287427,
            24.9752762360012,
            328.380934845646,
            105.531965883941,
            139.567326407853,
            139.567326407853,
            226.322278325374,
            152.204221415427,
            242.13181892178,
            316.200889778535,
            333.421572287427,
            24.9752762360012,
            328.380934845646,
            105.531965883941,
            139.567326407853,
            139.567326407853,
            271.123328059388,
            205.585315811037,
            213.10385755862,
            290.634122877769,
            342.073067198459,
            60.2107838686251,
            5.76532673402092,
            84.2807089696567,
            100.265022941512,
            123.669503648238,
            271.123328059388,
            205.585315811037,
            213.10385755862,
            290.634122877769,
            342.073067198459,
            60.2107838686251,
            5.76532673402092,
            84.2807089696567,
            100.265022941512,
            123.669503648238
          ),
          build_id = c(
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "365",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831",
            "831"
          ),
          BLDG_HT = c(
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            22.73,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07,
            19.07
          ),
          obs_id = c(
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            1L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L,
            2L
          ),
          height = c(
            22.74,
            22.74,
            22.74,
            22.74,
            22.74,
            22.74,
            19.08,
            19.08,
            19.08,
            19.08,
            19.08,
            19.08,
            5,
            5,
            5,
            5,
            5,
            5,
            5,
            5,
            5,
            5,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            5,
            5,
            5,
            5,
            5,
            5,
            5,
            5,
            5,
            5,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15
          )
        ),
        .Names = c(
          "type",
          "seg_id",
          "xy_id",
          "facade_az",
          "build_id",
          "BLDG_HT",
          "obs_id",
          "height"
        ),
        row.names = c(
          "1",
          "2",
          "3",
          "4",
          "5",
          "6",
          "7",
          "8",
          "9",
          "10",
          "11",
          "12",
          "110",
          "21",
          "31",
          "41",
          "51",
          "61",
          "71",
          "81",
          "91",
          "101",
          "113",
          "123",
          "13",
          "14",
          "15",
          "16",
          "17",
          "18",
          "19",
          "20",
          "111",
          "121",
          "131",
          "141",
          "151",
          "161",
          "171",
          "181",
          "191",
          "201",
          "112",
          "122",
          "132",
          "142",
          "152",
          "162",
          "172",
          "182",
          "192",
          "202"
        ),
        class = "data.frame"
      )
      ,
      coords.nrs = numeric(0)
      ,
      coords = structure(
        c(
          667907.571939006,
          667917.571939006,
          667927.571939006,
          667907.571939006,
          667917.571939006,
          667927.571939006,
          667917.571939006,
          667927.571939006,
          667937.571939006,
          667917.571939006,
          667927.571939006,
          667937.571939006,
          667911.182321722,
          667908.81713281,
          667903.060000456,
          667905.663089928,
          667913.16502473,
          667922.043864029,
          667926.38072157,
          667931.776158766,
          667925.610747157,
          667918.149139333,
          667911.182321722,
          667908.81713281,
          667903.060000456,
          667905.663089928,
          667913.16502473,
          667922.043864029,
          667926.38072157,
          667931.776158766,
          667925.610747157,
          667918.149139333,
          667928.623157747,
          667922.31034574,
          667913.74513528,
          667913.127173768,
          667918.514590853,
          667926.683035748,
          667934.16216899,
          667940.381465392,
          667940.738830277,
          667936.216743819,
          667928.623157747,
          667922.31034574,
          667913.74513528,
          667913.127173768,
          667918.514590853,
          667926.683035748,
          667934.16216899,
          667940.381465392,
          667940.738830277,
          667936.216743819,
          3538103.22116346,
          3538103.22116346,
          3538103.22116346,
          3538113.22116346,
          3538113.22116346,
          3538113.22116346,
          3538123.22116346,
          3538123.22116346,
          3538123.22116346,
          3538133.22116346,
          3538133.22116346,
          3538133.22116346,
          3538097.58769166,
          3538103.73369686,
          3538108.64450593,
          3538115.96441413,
          3538122.14955971,
          3538119.15618478,
          3538114.0389939,
          3538107.73779458,
          3538100.4172045,
          3538094.05953785,
          3538097.58769166,
          3538103.73369686,
          3538108.64450593,
          3538115.96441413,
          3538122.14955971,
          3538119.15618478,
          3538114.0389939,
          3538107.73779458,
          3538100.4172045,
          3538094.05953785,
          3538119.68057611,
          3538120.57495039,
          3538125.22656349,
          3538134.67137422,
          3538140.85043566,
          3538140.91758237,
          3538141.47221756,
          3538136.97937816,
          3538127.28418104,
          3538118.79274352,
          3538119.68057611,
          3538120.57495039,
          3538125.22656349,
          3538134.67137422,
          3538140.85043566,
          3538140.91758237,
          3538141.47221756,
          3538136.97937816,
          3538127.28418104,
          3538118.79274352,
          22.74,
          22.74,
          22.74,
          22.74,
          22.74,
          22.74,
          19.08,
          19.08,
          19.08,
          19.08,
          19.08,
          19.08,
          5,
          5,
          5,
          5,
          5,
          5,
          5,
          5,
          5,
          5,
          15,
          15,
          15,
          15,
          15,
          15,
          15,
          15,
          15,
          15,
          5,
          5,
          5,
          5,
          5,
          5,
          5,
          5,
          5,
          5,
          15,
          15,
          15,
          15,
          15,
          15,
          15,
          15,
          15,
          15
        ),
        .Dim = c(52L,
                 3L),
        .Dimnames = list(
          c(
            "1",
            "2",
            "3",
            "4",
            "5",
            "6",
            "7",
            "8",
            "9",
            "10",
            "11",
            "12",
            "110",
            "21",
            "31",
            "41",
            "51",
            "61",
            "71",
            "81",
            "91",
            "101",
            "113",
            "123",
            "13",
            "14",
            "15",
            "16",
            "17",
            "18",
            "19",
            "20",
            "111",
            "121",
            "131",
            "141",
            "151",
            "161",
            "171",
            "181",
            "191",
            "201",
            "112",
            "122",
            "132",
            "142",
            "152",
            "162",
            "172",
            "182",
            "192",
            "202"
          ),
          c("x1", "x2", "h")
        )
      )
      ,
      bbox = structure(
        c(
          667903.060000456,
          3538094.05953785,
          5,
          667940.738830277,
          3538141.47221756,
          22.74
        ),
        .Dim = c(3L, 2L),
        .Dimnames = list(c("x1", "x2", "h"), c("min", "max"))
      )
      ,
      proj4string = new("CRS"
                        , projargs = "+proj=utm +zone=36 +datum=WGS84 +units=m +no_defs +ellps=WGS84 +towgs84=0,0,0")
    )
    solar_pos = tmy[c(9, 16), c("sun_az", "sun_elev")]
    solar_pos = as.matrix(solar_pos)
    s = inShadow(
      location = location,
      obstacles = obstacles,
      obstacles_height_field = "BLDG_HT",
      solar_pos = solar_pos
    )
    },
    structure(c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE,
                FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE,
                TRUE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE,
                TRUE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE,
                TRUE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE,
                TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
                FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE,
                FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, FALSE, FALSE,
                FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE,
                FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE,
                FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE), .Dim = c(52L, 2L))
)

})
