% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{saturation}
\alias{brightness}
\alias{hueshift}
\alias{saturation}
\title{Query or change colour properties}
\usage{
saturation(shades, values = NULL)

brightness(shades, values = NULL)

hueshift(shades, angles = 0)
}
\arguments{
\item{shades}{One or more colours, in any suitable form (see
\code{\link{shade}}).}

\item{values}{New values for the property in question. If \code{NULL}, the
current value(s) will be returned.}

\item{angles}{For \code{hueshift}, the angles (in degrees) by which to
rotate the colour hues.}
}
\value{
Current colour property values, or new colours of class
  \code{\link{shade}}.
}
\description{
These functions obtain the value of a colour property, or modify it. They
will convert between colour spaces as required, but the RGB representation
will be appropriately updated in the result.
}
\examples{
saturation(c("papayawhip","lavenderblush","olivedrab"))
saturation("papayawhip", 0.7)
}
\author{
Jon Clayden <code@clayden.org>
}

