\name{krige}
\title{Kriging}
\usage{krige(prdpnt, point.obj, v1, var.mod.object,maxdist=NULLi,extrap=F) }
\alias{krige}
\arguments{
\item{prdpnt}{a point object, generated by \code{point()}, at which prediction is carried out}
\item{point.obj}{a point object, generated by \code{point()}, containing the sample points and data}
\item{v1}{the variable, contained in \code{point.obj}, for which prediction will be carried out}
\item{maxdist}{an optional maximum distance. If entered, then only sample points (i.e, in point.obj) within maxdist of each
prediction point will be used to do the prediction at that point. If not entered, then all n sample points will be used to make
the prediction at each point.}
\item{extrap}{logical, indicates if prediction outside the convex hull of data points should be done, default \code{FALSE}}
}
\value{A point object which is a copy of the prdpnt object with two new variables, \code{zhat} and \code{sigma2hat}, which are,
repspectively, the predicted value and the kriging variance. }
\description{Carry out spatial prediction (or kriging). }
\seealso{\code{\link{est.variogram}},\code{\link{fit.variogram}}}
\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="maas.vmod"))==0){example(fit.variogram)}
}
# a single point:
prdpnt <- point(data.frame(list(x=180000,y=331000)))
prdpnt <- krige(prdpnt, maas.point, 'zinc', maas.vmod)
prdpnt

# kriging on a grid (slow!)
grid <- list(x=seq(min(maas$x),max(maas$x),by=100),
             y=seq(min(maas$y),max(maas$y),by=100))
grid$xr <- range(grid$x)
grid$xs <- grid$xr[2] - grid$xr[1]
grid$yr <- range(grid$y)
grid$ys <- grid$yr[2] - grid$yr[1]
grid$max <- max(grid$xs, grid$ys)
grid$xy <- data.frame(cbind(c(matrix(grid$x, length(grid$x), length(grid$y))),
             c(matrix(grid$y, length(grid$x), length(grid$y), byrow=T))))
colnames(grid$xy) <- c("x", "y")
grid$point <- point(grid$xy)
grid$krige <- krige(grid$point,maas.point,'zinc',maas.vmod,
                    maxdist=1000,extrap=F)
op <- par(no.readonly = TRUE)
par(pty="s")
plot(grid$xy, type="n", xlim=c(grid$xr[1], grid$xr[1]+grid$max),
                    ylim=c(grid$yr[1], grid$yr[1]+grid$max))
image(grid$x,grid$y,
      matrix(grid$krige$zhat,length(grid$x),length(grid$y)),
      add=T)
contour(grid$x,grid$y,
        matrix(grid$krige$zhat,length(grid$x),length(grid$y)),
        add=T)
data(maas.bank)
lines(maas.bank$x,maas.bank$y,col="blue")
par(op)
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
