% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetime-cube-test.R
\name{is_spacetime_cube}
\alias{is_spacetime_cube}
\title{Test if a spacetime object is a spacetime cube}
\usage{
is_spacetime_cube(x, ...)
}
\arguments{
\item{x}{a spacetime object}

\item{...}{unused}
}
\description{
Given an object with class \code{spacetime}, determine if it is a \emph{spacetime cube}.
If the time-series is is irregular a warning is emitted
(see \code{\link[=validate_spacetime]{validate_spacetime()}} for more on the restrictions on the time column.
}
\details{
A spacetime object is a spacetime cube when it contains a regular time-series
representation of each geometry. That is, only one observation for at each
time period per geography is present.

The number of rows in a spacetime cube is the number of geographies multiplied
by the number of time periods. For example if there are 10 locations and 20
time periods, the number of rows must be 200.
}
\section{Validation}{


\code{is_spacetime_cube()} runs a number of checks that to ensure that the provided
object is in fact a spacetime cube. It checks that:
\itemize{
\item the number of rows is equal to the number of locations multiplied by the number
of time periods
\item each time period has an equal number of observations
\item each location has an equal number of observations
\item each combination of time period and location has only one observation
\item that the time-series is regular
}
}

\examples{
df_fp <- system.file("extdata", "bos-ecometric.csv", package = "sfdep")
geo_fp <- system.file("extdata", "bos-ecometric.geojson", package = "sfdep")

# read in data
df <- readr::read_csv(df_fp, col_types = "ccidD")
geo <- sf::read_sf(geo_fp)

# Create spacetime object called `bos`
bos <- spacetime(df, geo,
                .loc_col = ".region_id",
                .time_col = "time_period")

is_spacetime_cube(bos)
is_spacetime_cube(bos[round(runif(1000, 0, nrow(bos))),])
is_spacetime_cube(guerry)
}
