% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetime-methods.R
\name{as_sf}
\alias{as_sf}
\alias{as_spacetime}
\alias{as_spacetime.sf}
\title{Cast between \code{spacetime} and \code{sf} classes}
\usage{
as_sf(x, ...)

as_spacetime(x, .loc_col, .time_col, ...)

\method{as_spacetime}{sf}(x, .loc_col, .time_col, ...)
}
\arguments{
\item{x}{for \code{\link[=st_as_sf]{st_as_sf()}} a spacetime object. For \code{\link[=as_spacetime]{as_spacetime()}}
an sf object.}

\item{...}{arguments passed to merge.}

\item{.loc_col}{the quoted name of the column containing unique location identifiers.}

\item{.time_col}{the quoted name of the column containing time periods.}
}
\description{
Cast between \code{spacetime} and \code{sf} classes

Convert sf object to spacetime
}
\examples{

if (FALSE) {
df_fp <- system.file("extdata", "bos-ecometric.csv", package = "sfdep")
geo_fp <- system.file("extdata", "bos-ecometric.geojson", package = "sfdep")

# read in data
df <- readr::read_csv(df_fp, col_types = "ccidD")
geo <- sf::read_sf(geo_fp)

# Create spacetime object called `bos`
bos <- spacetime(df, geo,
                 .loc_col = ".region_id",
                 .time_col = "time_period")

as_sf(bos)
as_spacetime(as_sf(bos) , ".region_id", "year")

}

}
