% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimic.R
\name{mimic-on-off}
\alias{mimic-on-off}
\alias{mimic_on}
\alias{mimic_off}
\alias{is_mimic_on}
\title{Simulate the functions before truly running them}
\usage{
mimic_on()

mimic_off()

is_mimic_on()
}
\value{
nothing
}
\description{
These functions are used to simulate the main functions before truly running
them, to disable changes to the files and to the cloud.
}
\details{
These are used in most examples, so the user settings don't change
when running [utils::example()]. Internally, these change the options
`ss.mimic`, `ss.mimic.local` and `ss.mimic.cloud`.
}
\section{Functions}{
\itemize{
\item \code{mimic_on()}: Enable mimic and write mimic files

\item \code{mimic_off()}: Disable mimic

\item \code{is_mimic_on()}: Check if mimic is on

}}
\examples{
mimic_on()
if(interactive()) {
  sync()
}
mimic_off()
}
