% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testCrisp}
\alias{testCrisp}
\alias{checkCrisp}
\alias{assertCrisp}
\title{assert/check/test/Crisp}
\usage{
testCrisp(object, errormsg = "This is not crisp.")

checkCrisp(object, errormsg = "This is not crisp.")

assertCrisp(object, errormsg = "This is not crisp.")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is crisp.
}
\examples{
testCrisp(Set$new(1))
testCrisp(FuzzySet$new(1, 0.5))
}
