% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_FuzzySet.R, R/Set_FuzzySet_FuzzyTuple.R
\name{as.FuzzySet}
\alias{as.FuzzySet}
\alias{as.FuzzySet.numeric}
\alias{as.FuzzySet.list}
\alias{as.FuzzySet.matrix}
\alias{as.FuzzySet.data.frame}
\alias{as.FuzzySet.Set}
\alias{as.FuzzySet.FuzzySet}
\alias{as.FuzzySet.Interval}
\alias{as.FuzzySet.ConditionalSet}
\alias{as.FuzzyTuple}
\alias{as.FuzzyTuple.numeric}
\alias{as.FuzzyTuple.list}
\alias{as.FuzzyTuple.matrix}
\alias{as.FuzzyTuple.data.frame}
\alias{as.FuzzyTuple.Set}
\alias{as.FuzzyTuple.FuzzySet}
\alias{as.FuzzyTuple.Interval}
\alias{as.FuzzyTuple.ConditionalSet}
\title{Coercion to R6 \code{FuzzySet}/\code{FuzzyTuple}}
\usage{
as.FuzzySet(object)

\method{as.FuzzySet}{numeric}(object)

\method{as.FuzzySet}{list}(object)

\method{as.FuzzySet}{matrix}(object)

\method{as.FuzzySet}{data.frame}(object)

\method{as.FuzzySet}{Set}(object)

\method{as.FuzzySet}{FuzzySet}(object)

\method{as.FuzzySet}{Interval}(object)

\method{as.FuzzySet}{ConditionalSet}(object)

as.FuzzyTuple(object)

\method{as.FuzzyTuple}{numeric}(object)

\method{as.FuzzyTuple}{list}(object)

\method{as.FuzzyTuple}{matrix}(object)

\method{as.FuzzyTuple}{data.frame}(object)

\method{as.FuzzyTuple}{Set}(object)

\method{as.FuzzyTuple}{FuzzySet}(object)

\method{as.FuzzyTuple}{Interval}(object)

\method{as.FuzzyTuple}{ConditionalSet}(object)
}
\arguments{
\item{object}{object to coerce}
}
\description{
Coerces object to an R6 \link{FuzzySet}/\link{FuzzyTuple}
}
\details{
\itemize{
\item \code{as.FuzzySet.list} - Assumes \code{list} has two items, named \code{elements} and \code{membership},
and that they are ordered to be corresponding.
\item \code{as.FuzzySet.matrix} - Assumes first column corresponds to \code{elements} and second column corresponds
to their respective \code{membership}.
\item \code{as.FuzzySet.data.frame} - First checks to see if one column is called \code{elements} and the other is called \code{membership}.
If not then uses \code{as.FuzzySet.matrix}.
\item \code{as.FuzzySet.Set} - Creates a \link{FuzzySet} by assuming \link{Set} elements all have \code{membership} equal to \eqn{1}.
\item \code{as.FuzzySet.Interval} - First tries coercion via \link{as.Set.Interval} then uses \link{as.FuzzySet.Set}.
}
}
\seealso{
\link{FuzzySet} \link{FuzzyTuple}

Other coercions: 
\code{\link{as.Interval}()},
\code{\link{as.Set}()}
}
\concept{coercions}
