% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateModel.R
\name{evaluateModel}
\alias{evaluateModel}
\title{The adaptive shrinkage estimate for generalized estimating equations}
\usage{
evaluateModel(family, corstr, y, x, clusterID, criterion = "QIC",
  theta = 0.75, gamma = 1, leastVar = 3, mostVar = ncol(x))
}
\arguments{
\item{family}{A description of the error distribution and link function to be
used in the model. See family for details of \code{\link{family}}
functions.}

\item{corstr}{A character string specifying the correlation structure. The
following are permitted: "independence", "exchangeable" and "ar1".}

\item{y}{The response data.}

\item{x}{A data frame contains the covariate vectors.}

\item{clusterID}{The id for each subject in the initial samples. Note that
the subjects in the same cluster will have identical id.}

\item{criterion}{The model selection criteria, one of the 'PWD' or 'QIC'.}

\item{theta}{The parameters of the adaptive shrinkage estimate.}

\item{gamma}{The parameters of the adaptive shrinkage estimate.}

\item{leastVar}{The minimum number of variables.}

\item{mostVar}{The maximum number of variables.}
}
\value{
a list containing the following components
\item{rho}{the correlation coefficient of the clusters}
\item{beta}{parameters that we estimate under the current samples}
\item{sandwich}{the sandwich information matrix for covariance}
\item{nonZeroIdx}{the index of the non zero coefficients}
\item{call}{a list containing several matrices including the sandwich matrix}
}
\description{
\code{evaluateModel} is used to get a generalized estimating equation of the
data by the adaptive shrinkage estimate method.
}
\details{
evaluateModel fits the current data by generalized estimating equations(GEE)
according to the value of the family argument and the corstr argument. We
should notice that this is not the ordinary generalized estimating equations.
It can determine the variables that have an impact on the response which
called effective variables. We use model selection criteria like the QIC
criterion to choose the optimal value.
}
